#include "NpDialogsSony.h"
#include "RankingSony.h"
#include "UserProfileSony.h"
#include "MessagePipe.h"
#include "ErrorCodesSony.h"


using namespace sce::Toolkit::NP;
using namespace sce::Toolkit::NP::Utilities;

namespace UnityPlugin
{
#if NP_HAS_NP_DIALOGS
	NpDialogs gNpDialogs;

	PRX_EXPORT bool PrxNpIsDialogOpen()
	{
		return gNpDialogs.IsDialogOpen();
	}

	DO_EXPORT( bool, PrxNpDialogsGetLastError) (ResultCode* result)
	{
		return gNpDialogs.GetLastError(result);
	}

	PRX_EXPORT ErrorCode PrxNpDialogFriendsList()
	{
		return gNpDialogs.StartFriendsListDialog();
	}

	PRX_EXPORT ErrorCode PrxNpDialogSharedPlayHistory()
	{
		return gNpDialogs.StartSharedHistoryDialog();
	}

	PRX_EXPORT ErrorCode PrxNpDialogProfile(const unsigned char* npID)
	{
		return gNpDialogs.StartProfileDialog(npID);
	}

	DO_EXPORT( ErrorCode, PrxNpDialogCommerce ) (int mode, uint64_t features)
	{
		return NP_ERR_NOT_SUPPORTED;
	}


	PRX_EXPORT ErrorCode PrxNpDialogGetResult(NpDialogReturn* result)
	{
		return gNpDialogs.GetResult(result);
	}

	NpDialogs::NpDialogs()
		: m_Busy(false)
		, m_DialogOpen(false)
		, m_ActiveDialog(kNpDlgNone)
		, m_LastResult("NpDialogs")
	{
	}

	bool NpDialogs::IsBusy()
	{
		return m_Busy;
	}

	bool NpDialogs::LoadModules()
	{
		if(sceSysmoduleIsLoaded(SCE_SYSMODULE_HTTPS) != SCE_OK)
		{
			sceSysmoduleLoadModule(SCE_SYSMODULE_HTTPS);
		}

		if(sceSysmoduleIsLoaded(SCE_SYSMODULE_NP_UTILITY) != SCE_OK)
		{
			sceSysmoduleLoadModule(SCE_SYSMODULE_NP_UTILITY);
		}
		// Also requires that sceSslInit(), sceHttpInit() and sceNpInit() have been called but this should already have happend when npToolkit was initialised.

		return true;
	}
	
	ErrorCode NpDialogs::StartFriendsListDialog()
	{
		m_LastResult.Reset();

		if(!m_DialogOpen && !m_Busy)
		{
			LoadModules();

			int ret = SCE_OK;
			SceNpFriendListDialogParam flDlParam;
			sceNpFriendListDialogParamInit(&flDlParam);
			flDlParam.mode = SCE_NP_FRIENDLIST_DIALOG_MODE_FRIENDLIST;
			ret = sceNpFriendListDialogInit(&flDlParam);
			if(ret != SCE_OK)
			{
				return m_LastResult.SetResultSCE(ret, true, __FUNCTION__, __LINE__);
			}

			m_ActiveDialog = kNpDlgFriendsList;
			m_DialogOpen = true;
			m_Busy = true;
		}
		else
		{
			Messages::LogWarning("Dialog already open\n");
		}

		return m_LastResult.GetResult();
	}

	ErrorCode NpDialogs::StartSharedHistoryDialog()
	{
		m_LastResult.Reset();

		if(!m_DialogOpen && !m_Busy)
		{
			LoadModules();

			int ret = SCE_OK;
			SceNpFriendListDialogParam flDlParam;
			sceNpFriendListDialogParamInit(&flDlParam);
			flDlParam.mode = SCE_NP_FRIENDLIST_DIALOG_MODE_PLAYERHISTORY;
			ret = sceNpFriendListDialogInit(&flDlParam);
			if(ret != SCE_OK)
			{
				return m_LastResult.SetResultSCE(ret, true, __FUNCTION__, __LINE__);
			}

			m_ActiveDialog = kNpDlgSharedPlayHistory;
			m_DialogOpen = true;
			m_Busy = true;
		}
		else
		{
			Messages::LogWarning("Dialog already open\n");
		}

		return m_LastResult.GetResult();
	}

	ErrorCode NpDialogs::StartProfileDialog(const unsigned char* npID)
	{
		m_LastResult.Reset();

		if(!m_DialogOpen && !m_Busy)
		{
			LoadModules();

			memcpy(&m_npID, npID, sizeof(SceNpId));

			int ret = SCE_OK;
			SceNpProfileDialogParam prDlParam;
			sceNpProfileDialogParamInit(&prDlParam);
			prDlParam.mode = SCE_NP_PROFILE_DIALOG_MODE_NORMAL;

			memcpy(&prDlParam.npid, &m_npID, sizeof(SceNpId));
			ret = sceNpProfileDialogInit(&prDlParam);
			if(ret != SCE_OK)
			{
				m_LastResult.SetResultSCE(ret, true, __FUNCTION__, __LINE__);
			}

			m_ActiveDialog = kNpDlgProfile;
			m_DialogOpen = true;
			m_Busy = true;
		}
		else
		{
			Messages::LogWarning("Dialog already open\n");
		}

		return m_LastResult.GetResult();
	}


	void NpDialogs::UpdateFriendsDialog()
	{
		SceCommonDialogStatus status = sceNpFriendListDialogGetStatus();
		if (status == SCE_COMMON_DIALOG_STATUS_FINISHED)
		{
			int ret = SCE_OK;

			SceNpFriendListDialogResult flDlgResult;
			memset(&flDlgResult, 0, sizeof(flDlgResult));

			ret = sceNpFriendListDialogGetResult(&flDlgResult);
			if(ret != SCE_OK)
			{
				Messages::LogError("NpDialogs::%s@L%d - %s", __FUNCTION__, __LINE__, LookupSceErrorCode(ret));
			}

//			printf("FlDialogResult = 0x%x\n", flDlgResult.result);
			if (flDlgResult.result == SCE_OK)
			{
				memcpy(&m_npID, &flDlgResult.npId, sizeof(SceNpId));
			}

			ret = sceNpFriendListDialogTerm();
			if(ret != SCE_OK)
			{
				Messages::LogError("NpDialogs::%s@L%d - %s", __FUNCTION__, __LINE__, LookupSceErrorCode(ret));
			}

			if ((SCE_OK == ret) && (SCE_OK == flDlgResult.result))
			{
				m_Result.result = kNpDlgOK;
				m_Result.npID = (unsigned char*)&m_npID;
				m_Result.npIDSize = sizeof(SceNpId);
				m_ActiveDialog = kNpDlgNone;
				m_DialogOpen = false;
				m_Busy = false;
				UnityPlugin::Messages::AddMessage(UnityPlugin::Messages::kNPToolKit_DlgFriendsClosed);
			}
			else if (SCE_COMMON_DIALOG_RESULT_USER_CANCELED == flDlgResult.result)
			{
				m_Result.result = kNpDlgCanceled;
				m_Result.npID = (unsigned char*)&m_npID;
				m_Result.npIDSize = sizeof(SceNpId);
				m_ActiveDialog = kNpDlgNone;
				m_DialogOpen = false;
				m_Busy = false;
				UnityPlugin::Messages::AddMessage(UnityPlugin::Messages::kNPToolKit_DlgFriendsClosed);
			}
			else
			{
				Messages::LogError("NpDialogs::%s@L%d - %s", __FUNCTION__, __LINE__, LookupSceErrorCode(flDlgResult.result));
				m_Result.result = kNpDlgCanceled;
				m_Result.npID = (unsigned char*)&m_npID;
				m_Result.npIDSize = sizeof(SceNpId);
				m_ActiveDialog = kNpDlgNone;
				m_DialogOpen = false;
				m_Busy = false;
				UnityPlugin::Messages::LogWarning("NP dialog closed with unhandled return state");
			}
		}
	}
	
	void NpDialogs::UpdateSharedPlayHistoryDialog()
	{
		if (sceNpFriendListDialogGetStatus() == SCE_COMMON_DIALOG_STATUS_FINISHED)
		{
			int ret = SCE_OK;

			SceNpFriendListDialogResult flDlgResult;

			ret = sceNpFriendListDialogGetResult(&flDlgResult);
			if(ret != SCE_OK)
			{
				Messages::LogError("NpDialogs::%s@L%d - %s", __FUNCTION__, __LINE__, LookupSceErrorCode(ret));
			}

			printf("FlDialogResult = 0x%x\n", flDlgResult.result);


			if (SCE_OK == flDlgResult.result)
			{
				memcpy(&m_npID, &flDlgResult.npId, sizeof(SceNpId));
			}

			ret = sceNpFriendListDialogTerm();
			if(ret != SCE_OK)
			{
				Messages::LogError("NpDialogs::%s@L%d - %s", __FUNCTION__, __LINE__, LookupSceErrorCode(ret));
			}

			if ((SCE_OK == ret) && (SCE_OK == flDlgResult.result))
			{
				m_Result.result = kNpDlgOK;
				m_Result.npID = (unsigned char*)&m_npID;
				m_Result.npIDSize = sizeof(SceNpId);
				m_ActiveDialog = kNpDlgNone;
				m_DialogOpen = false;
				m_Busy = false;
				UnityPlugin::Messages::AddMessage(UnityPlugin::Messages::kNPToolKit_DlgSharedPlayHistoryClosed);
			}
			else if (SCE_COMMON_DIALOG_RESULT_USER_CANCELED == flDlgResult.result)
			{
				m_Result.result = kNpDlgCanceled;
				m_Result.npID = (unsigned char*)&m_npID;
				m_Result.npIDSize = sizeof(SceNpId);
				m_ActiveDialog = kNpDlgNone;
				m_DialogOpen = false;
				m_Busy = false;
				UnityPlugin::Messages::AddMessage(UnityPlugin::Messages::kNPToolKit_DlgSharedPlayHistoryClosed);
			}
			else
			{
				m_ActiveDialog = kNpDlgNone;
				m_DialogOpen = false;
				m_Busy = false;
				UnityPlugin::Messages::LogWarning("NP dialog closed with unhandled return state");
			}
		}
	}

	void NpDialogs::UpdateProfileDialog()
	{
		SceCommonDialogStatus status = sceNpProfileDialogGetStatus();
		if (status == SCE_COMMON_DIALOG_STATUS_FINISHED)
		{
			int ret = SCE_OK;

			SceNpProfileDialogResult prDlgResult;
			memset(&prDlgResult, 0, sizeof(prDlgResult));

			ret = sceNpProfileDialogGetResult(&prDlgResult);
			if(ret != SCE_OK)
			{
				Messages::LogError("NpDialogs::%s@L%d - %s", __FUNCTION__, __LINE__, LookupSceErrorCode(ret));
			}

			ret = sceNpProfileDialogTerm();

			if(ret != SCE_OK)
			{
				Messages::LogError("NpDialogs::%s@L%d - %s", __FUNCTION__, __LINE__, LookupSceErrorCode(ret));
			}

			m_Result.result = kNpDlgOK;
			m_Result.npID = (unsigned char*)&m_npID;
			m_Result.npIDSize = sizeof(SceNpId);
			m_ActiveDialog = kNpDlgNone;
			m_DialogOpen = false;
			m_Busy = false;

			UnityPlugin::Messages::AddMessage(UnityPlugin::Messages::kNPToolKit_DlgProfileClosed);
		}
	}


	ErrorCode NpDialogs::GetResult(NpDialogReturn* result)
	{
		memcpy(result, &m_Result, sizeof(NpDialogReturn));
		return NP_OK;
	}

	void NpDialogs::Update()
	{
		if (m_DialogOpen)
		{
			switch(m_ActiveDialog)
			{
				case kNpDlgFriendsList:
					UpdateFriendsDialog();
					break;

				case kNpDlgSharedPlayHistory:
					UpdateSharedPlayHistoryDialog();
					break;

				case kNpDlgProfile:
					UpdateProfileDialog();
					break;

				case kNpDlgNone:
					break;
			}
		}
	}
#else	// Unsupported
	DO_EXPORT( bool, PrxNpIsDialogOpen ) ()
	{
		return false;
	}

	DO_EXPORT( ErrorCode, PrxNpDialogFriendsList ) ()
	{
		UnityPlugin::Messages::LogError("PrxNpDialogFriendsList: Not supported on this platform");
		return NP_ERR_NOT_SUPPORTED;
	}

	DO_EXPORT( ErrorCode, PrxNpDialogSharedPlayHistory ) ()
	{
		UnityPlugin::Messages::LogError("PrxNpDialogSharedPlayHistory: Not supported on this platform");
		return NP_ERR_NOT_SUPPORTED;
	}

	DO_EXPORT( ErrorCode, PrxNpDialogProfile ) (const unsigned char* npID)
	{
		UnityPlugin::Messages::LogError("PrxNpDialogProfile: Not supported on this platform");
		return NP_ERR_NOT_SUPPORTED;
	}

	DO_EXPORT( ErrorCode, PrxNpCommerceProfile ) (int mode)
	{
		UnityPlugin::Messages::LogError("PrxNpCommerceProfile: Not supported on this platform");
		return NP_ERR_NOT_SUPPORTED;
	}


	DO_EXPORT( ErrorCode, PrxNpDialogGetResult ) (NpDialogReturn* result)
	{
		UnityPlugin::Messages::LogError("PrxNpDialogGetResult: Not supported on this platform");
		memset(result, 0, sizeof(NpDialogReturn));
		static SceNpId dummyNpID;
		memset(&dummyNpID, 0, sizeof(dummyNpID));
		result->npID = (unsigned char*)&dummyNpID;
		result->npIDSize = sizeof(SceNpId);
		return NP_ERR_NOT_SUPPORTED;
	}

#endif

} // namespace UnityPlugin
